﻿using Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ZSMusic.Model;
using Newtonsoft.Json;
using ZSMusic.Model;
using ZSMusic.DAL;

namespace ZSMusic.BLLEX
{
    public static class MusicHelper
    {
        public static bool Online { get; set; }

        public static string Address { get; set; }

        public static void FirstRun(object o)
        {
            Info.FirstRun(o);
        }

        public static object Tag { get { return Info.Tag; } set { Info.Tag = value; } }

        public static List<MusicSource> GetAllSources()
        {
            List<MusicSource> list = new List<Model.MusicSource>();
            if (Online)
            {
                string src = HttpHelper.Get(string.Format("{0}/sources.aspx", Address));
                if (src.Contains("Exception"))
                {
                    throw JsonConvert.DeserializeObject<Exception>(src);
                }
                if (!src.Contains("Value"))
                { throw new Exception(src); }
                return JsonConvert.DeserializeObject<List<MusicSource>>(src);
            }
            else
            {
                return DAL.Info.Sources;
            }
        }

        public static List<Music> Search(string pams)
        {
            //source&word&page&num
            string[] data = pams.Split('&');
            string source = data[0];
            string word = data[1];
            int page = int.Parse(data[2]);
            int num = int.Parse(data[3]);
            return Search(source, word, page, num);
        }

        public static List<Music> Search(string source, string word, int page = 1, int num = 30)
        {
            if (Online)
            {
                string src = HttpHelper.Get(string.Format("{0}/search.aspx?source={1}&word={2}&page={3}&num={4}", Address, source, word, page, num));
                try
                {
                    if (src.Contains("Exception"))
                    {
                        throw JsonConvert.DeserializeObject<Exception>(src);
                    }
                    if (!src.Contains("[{"))
                    { throw new Exception(src); }
                    return JsonConvert.DeserializeObject<List<Music>>(src);
                }
                catch (Exception)
                {
                    throw;
                }

            }
            else
            {
                return ZSMusic.BLL.MusicHelper.Search(source, word, page, num);
            }
        }

        public static Music GetData(string pams)
        {
            //source&id&name&artist&album&albumid
            string[] data = pams.Replace("&&", "& &").Trim('&').Split('&');
            Music m = new Model.Music();
            m.Source = data[0];
            m.Id = data[1];
            m.Name = data[2];
            m.Artist = data[3];
            m.Album = data[4];
            if (data.Length == 6)
            {
                m.AlbumId = data[5];
            }
            return GetData(m);
        }

        public static Music GetData(Music m)
        {
            if (Online)
            {
                string src = HttpHelper.Get(string.Format(
               "{0}/getdata.aspx?source={1}&id={2}&name={3}&artist={4}&album={5}&albumid={6}&type=all&redirect=0"
               , Address, m.Source, m.Id, m.Name, m.Artist, m.Album, m.AlbumId));
                try
                {
                    if (src.Contains("Exception"))
                    {
                        throw JsonConvert.DeserializeObject<Exception>(src);
                    }
                    if (!src.Contains("Name"))
                    { throw new Exception(src); }
                    return JsonConvert.DeserializeObject<Music>(src);
                }
                catch (Exception)
                {
                    throw;
                }
            }
            else
            {
                ZSMusic.BLL.MusicHelper.GetData(m);
                return m;
            }
        }

        /// <summary>
        /// 重新搜索
        /// </summary>
        /// <param name="s">下架的歌曲</param>
        /// <param name="similar">最低准确率</param>
        /// <returns></returns>
        public static Music ReSearch(Music m, double similar = 0.75, string type = "all")
        {
            if (Online)
            {
                string src = HttpHelper.Get(string.Format(
   "{0}/research.aspx?artist={1}&name={2}&similar={3}&type={4}&redirect=0"
   , Address, m.Artist, m.Name, similar, type));
                try
                {
                    if (src.Contains("Exception"))
                    {
                        throw JsonConvert.DeserializeObject<Exception>(src);
                    }
                    if (!src.Contains("Name"))
                    { throw new Exception(src); }
                    return JsonConvert.DeserializeObject<Music>(src);
                }
                catch (Exception)
                {
                    throw;
                }
            }
            else
            {
                return ZSMusic.BLL.MusicHelper.ReSearch(m, similar, type);
            }
        }

        public static Music ReSearch(string artist, string name, double similar = 0.75, string type = "all")
        {
            Music m = new Music();
            m.Artist = artist;
            m.Name = name;
            return ReSearch(m, similar, type);
        }
        public static User Regist()
        {
            string src = HttpHelper.Get(string.Format("{0}/regist.aspx", Address));
            try
            {
                if (src.Contains("Exception"))
                {
                    throw JsonConvert.DeserializeObject<Exception>(src);
                }
                if (!src.Contains("Name"))
                { throw new Exception(src); }
                return JsonConvert.DeserializeObject<User>(src);
            }
            catch (Exception)
            {
                throw;
            }
        }

        public static User QuaryUser(string key)
        {
            string src = HttpHelper.Get(string.Format("{0}/user.aspx?apikey={1}", Address, key));
            try
            {
                if (src.Contains("Exception"))
                {
                    throw JsonConvert.DeserializeObject<Exception>(src);
                }
                if (!src.Contains("Name"))
                { throw new Exception(src); }
                return JsonConvert.DeserializeObject<User>(src);
            }
            catch (Exception)
            {
                throw;
            }
        }

        public static bool SendReport(Exception ex)
        {
            try
            {
                Dictionary<string, string> dic = new Dictionary<string, string>();
                dic.Add("json", JsonConvert.SerializeObject(ex));
                string src = HttpHelper.Post(string.Format("{0}/sendreport.aspx", Address), dic);
                return src.ToLower() == "true";
            }
            catch (Exception)
            {
                return false;
            }
        }

        public static List<VersionInfo> GetUpdate()
        {
            string src = HttpHelper.Get(string.Format("{0}/update.txt", Address));
            if (src.Contains("Exception"))
            {
                throw JsonConvert.DeserializeObject<Exception>(src);
            }
            if (!src.Contains("["))
            { throw new Exception(src); }
            return JsonConvert.DeserializeObject<List<VersionInfo>>(src);
        }

    }
}
